/************************************************/
/* IPB3 Javascript								*/
/* -------------------------------------------- */
/* ips.uportal.js - Unreal Portal code			*/
/* (c) IPS, Inc 2008							*/
/* -------------------------------------------- */
/* Author: Rikki Tissier						*/
/* Modified By: Shahmir Noorani					*/
/************************************************/

var _idx = window.IPBoard;

_idx.prototype.uportal = {
	/*------------------------------*/
	/* Constructor 					*/
	init: function()
	{
		Debug.write("Initializing ips.uportal.js");
		
		document.observe("dom:loaded", function(){
			ipb.uportal.setUpForumTables();
		});
	},
	
	/* ------------------------------ */
	/**
	 * Inits the forum tables ready for collapsing
	*/
	setUpForumTables: function()
	{
		$$('.ipb_table').each( function(tab){
			var tmp = $( tab ).wrap( 'div' );
			$( tmp ).addClassName('table_wrap');
		});
		
		$$('.category_block').each( function(cat){
			$(cat).select('.toggle')[0].observe( 'click', ipb.uportal.toggleCat );			
		});	
		
		cookie = ipb.Cookie.get('toggleUportalCats');
		
		if( cookie )
		{
			var cookies = cookie.split( ',' );
			
			//-------------------------
			// Little fun for you...
			//-------------------------
			for( var abcdefg=0; abcdefg < cookies.length; abcdefg++ )
			{
				if( cookies[ abcdefg ] )
				{
					var wrapper	= $( 'category_' + cookies[ abcdefg ] ).up('.category_block').down('.table_wrap');
					
					wrapper.hide();
					$( 'category_' + cookies[ abcdefg ] ).addClassName('collapsed');
				}
			}
		}
	},
	
	/* ------------------------------ */
	/**
	 * Show/hide a category
	 * 
	 * @var		{event}		e	The event
	*/
	toggleCat: function(e)
	{
		if( ipb.uportal.animating ){ return false; }
		
		
		var click = Event.element(e);
		var remove = $A();
		var wrapper = $( click ).up('.category_block').down('.table_wrap');
		Debug.write( wrapper );
		$( wrapper ).identify(); // IE8 fix
		catname = $( click ).up('h3');
		var catid = catname.id.replace('category_', '');
		
		ipb.uportal.animating = true;
		
		// Get cookie
		cookie = ipb.Cookie.get('toggleUportalCats');
		if( cookie == null ){
			cookie = $A();
		} else {
			cookie = cookie.split(',');
		}
		
		Effect.toggle( wrapper, 'blind', {duration: 0.4, afterFinish: function(){ ipb.uportal.animating = false; } } );
		
		if( catname.hasClassName('collapsed') )
		{
			catname.removeClassName('collapsed');
			remove.push( catid );
		}
		else
		{
			new Effect.Morph( $(catname), {style: 'collapsed', duration: 0.4, afterFinish: function(){
				$( catname ).addClassName('collapsed');
				ipb.uportal.animating = false;
			} });
			cookie.push( catid );
		}
		
		cookie = "," + cookie.uniq().without( remove ).join(',') + ",";
		
		ipb.Cookie.set('toggleUportalCats', cookie, 1);
		
		Event.stop( e );
	}
}

ipb.uportal.init();